s = tf('s');
close all;

% Controller Gains and transfer function
Kp = 0.5; % Change proportional gain here
Kd = 0.15; % Change derivative gain here
Ki = 4; % Change to the integral 

Ke2c = Kp + Kd*s + Ki/s; % Error to motor command 

% Motor Command to angular acceleration
% Adjust Beta and Ga so that your arm's response to sines match.
Ga = 10; % Change to match model
Beta = -10;  % Change to adjust model
Hc2a = 1;  %% fix this %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Angular acceleration to angle transfer function
Ha2t = 1;  %% fix this %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Determine closed look transfer function
Gs = feedback(Ke2c*Hc2a*Ha2t,1);  

% Plots (1)Bode (2,3)Mag,Phase versus freq (hertz) (4) Step response
figure(1);
bode(Gs); % This function plots 20log(|Gs|) (in DB) vs Omega (in rads/sec)
thickBode(Gs,2);  % Gives you |Gs| and angle(Gs) vs f (hertz)
figure(4);
step(Gs,5);  % Closed loop step response

%plot function on linear scale
figure(5)
plotoptions = bodeoptions;
plotoptions.Grid = 'on';
plotoptions.FreqUnits = 'Hz';
plotoptions.MagScale = 'linear';
plotoptions.MagUnits ='abs';
plotoptions.FreqScale = 'linear';
bodeplot(Gs,plotoptions)
xlim([0 5])


function thickBode(sys,fignum)  % plots bode versus freq in hertz
[mag,phase,wout] = bode(sys, {1.0e-1,1.0e2});
Mag = mag(:); Phase=phase(:);
fout = wout/(2*pi);
figure(fignum); loglog(fout,Mag,'LineWidth',3);grid on; hold on;
title("Magnitude versus frequency (hertz) (log-log scale)");
xlabel("Frequency in Cycles per second");
ylabel("Magnitude");
figure(fignum+1);semilogx(fout,Phase,'LineWidth',3);grid on; hold on;
title("Phase (degrees) versus) frequency(hertz) (log-linear scale)");
ylabel("Phase in Degrees");
xlabel("Frequency in Cycles per second");
end
