% ******************************************************************************
% Script to compute state-feedback gains for a single-input single-output
% third-order system, using pole placement, then lqr, then lqr with an
% additional integral state.
%
% Input: matrices A(3x3), B(3x1), C(1x3) and D(1x1) for a system described by
%     d/dt x(t) = Ax(t) + Bu(t), y(t) = Cx(t) + Du(t)%
%
% Output K(1x3) and Kr, state gains and input scaling
% or
% Output K(1x4) where K(1) is the gain on the integral state,
%
% K's are determined using pole placement or LQR
% ******************************************************************************

% Good practice to do every time!
close all;
clearvars;

%%**************** FLAGS TO SET***************************
% Use Ky for Kr.
useKyForKr = true;  % Set false to use correct Kr!

% Pick approach to controller gains (default is manual K's)
% If both true, Klqr is used.
useKplace = false;  % Set to true for checkoff 3
useKlqr = false;   % Set to true for checkoff 4&5

% Add the integral state
addIntegral = false; % Set to true for checkoff 5
%%*******************END OF FLAGS TO SET ***********************


% -------------------------------------------------------------------
% TODO (Checkoff 2): Calibrate model (start with TF model from lab 4)
% --------------------------------------------------------------------

% Import first guess at params using lab4 transfer function model
LamE = -50;  % FIX THIS FIRST
Gamma = 200;  % FIX THIS FIRST
Gdady = 600;  % FIX THIS FIRST

% Scale should be adjusted to match icoil to measurements.
scale = 1.0;    % FIX THIS FIRST

% Gdidc*Gdadi = Gamma
Gdidc = sqrt(Gamma)/scale;  
Gdadi = scale*sqrt(Gamma);

% Allocate the state-space matrices A, B, and C.
A = zeros(3); % The 3x3 A matrix (3 rows (eqns) by 3 cols (states)
B = zeros(3,1); % The 3x1 B matrix (3 rows (eqns) by 1 col (scalar u)
C = zeros(1,3); % The 1x3 C matrix (1 row (scalar out) by 3 cols (states)

% First Row of A and B, icoil equation, given in lab write-up
A(1,1) = LamE;
A(1,2) = 0.0;
A(1,3) = 0.0;
B(1)   = -LamE*Gdidc;
s1     = 'icoil';  % coil current is state 1.

% Second Row, velocity equation
A(2,1) = 0;   % FIX THIS FIRST
A(2,2) = 0;   % FIX THIS FIRST
A(2,3) = 0;   % FIX THIS FIRST
B(2)   = 0;   % FIX THIS FIRST
s2     = 'v'; % Velocity is state 2.

% Third Row, position equation
A(3,1) = 0.0;  % FIX THIS FIRST
A(3,2) = 0.0;  % FIX THIS FIRST
A(3,3) = 0.0;  % FIX THIS FIRST
B(3)   = 0.0;  % FIX THIS FIRST
s3     = 'y';  % Position is state 3.

% Output matrix selects state 3, position.
C = [0.0, 0.0, 1.0];  

% The instantaneous u-to-y term (D) is zero.
D = 0;

% Convert to a system data structure
sys = ss(A, B, C, D, 'StateName', {s1,s2,s3});

% Print input-output transfer function from state-space
fprintf('Open Loop System\n')
tfsys = tf(sys);
if tfsys.num{1}(end) ~= 0
    ps = pole(sys);
    fprintf('Poles:%f,%f,%f\n', ps(1),ps(2),ps(3));
    display(tfsys);
end


% -----------------------------------------------------------------------
% TODO (Checkoff 2/3): pick the K's manually
% -----------------------------------------------------------------------
Kman = [0.0 0.0 0.0]; % FIX THIS FIRST

% -------------------------------------------------------
% TODO (Checkoff 3): specify pole locations
% -------------------------------------------------------
poles = [-500, -501, -502]; % FIX THIS SECOND
if(useKplace)
    Kplace = place(sys.A,sys.B,poles);
end

% ----------------------
% TODO (Checkoff 4): Use LQR to pick gains
% ----------------------
% Select state weights Q, and control weights R
Q = diag([1,1,1]);  % FIX THIS THIRD!
R = 1;  % FIX THIS THIRD
if(useKlqr)
    Klqr = lqr(sys,Q,R);
end

% Select which controller gains to use
if useKlqr == true
    K = Klqr;
    fprintf('Using LQR ');
elseif useKplace == true
    K = Kplace;
    fprintf('Using pole-placement ');
else
    K = Kman;
    fprintf('Using manual gains ');
end

% ---------------------------------------------------
% TODO (Checkoff 4):  Plot the phase margin for the controller
% ---------------------------------------------------
sysph = ss(A, B, C, D);  % FIX THIS THIRD
figure(2);
margin(sysph);


% ---------------------------------------------------
% TODO (Checkoff 2): define matrices Acl,Bcl,Ccl, and Dcl
% ---------------------------------------------------
% Recall that u = Kr*y_d - K*x for the open loop system, and that for the
% closed-loop system described by Acl,Bcl,Ccl,Dcl matrices,
% dx/dt = Acl*x + Bcl*y_d and y = Ccl*x + Dcl*y_d
Acl = A;  % FIX THIS FIRST

if useKyForKr
    Kr = Kman(3); % Where does this formula come from?
else
    Kr = -1/(C*(Acl\B));  % Where does this formula come from?
end

Bcl = B;  % FIX THIS FIRST
Ccl = C;    
Dcl = D;     

% Print closed-loop transfer function.
fprintf('Closed Loop System\n')
sys_cl = ss(Acl, Bcl, Ccl, Dcl);
tfsys_cl = tf(sys_cl);
if tfsys.num{1}(end) ~= 0
    ps = pole(sys_cl);
    fprintf('Poles:%f,%f,%f\n', ps(1),ps(2),ps(3));
    display(tfsys_cl);
end


% The Cplot and Dplot matrices below are set so that the second through
% fourth elements of Cplot*x + Dplot*y_d are the three states. We replace
% the zero elements in Cplot and Dplot below so that the first element
% of Cplot*x + Dplot*y_d is equal to the command, u = Kr*y_d - K*x.
Cplot = [-K; eye(3)];
Dplot = [Kr; zeros(3,1);];

% Create the closed loop system with extra outputs for plotting.
sys_cl = ss(Acl, Bcl, Cplot, Dplot,'OutputName', {'cmd', s1, s2, s3});

% Plot step response of the command and all three states
figure(1);
step(sys_cl, 1.0);

% Print out lines to copy and paste to the Teensy
fprintf('Copy-paste lines below into Teensy Sketch!\n');
fprintf('#define offsetK%s %f \n#define offsetK%s %f \n#define offsetK%s %f \n#define offsetKr %f\n', s1,K(1),s2,K(2),s3,K(3), Kr);
fprintf('\n\n')


if addIntegral

    % ******************************************************************
    % Checkoff 5: Now let's add in the integrator, while still using LQR
    %             Make sure to remove the block comment, %{ and %}
    % ******************************************************************


    % augment the original equations
    % p indicates matrices for controller with an integral
    Bp = [0; B];
    Cp = [0 C];
    Dp = D;
    Ap = zeros(4);
    Ap(2:4,:) = [zeros(3,1) A]; % we set the last 3 rows of Ap for you

    % ------------------------------
    % TODO (Checkoff 5): Complete Ap
    % ------------------------------
    Ap(1, :) = [0 0 0 0];  %FIX THIS FOURTH

    % Convert to a system
    sysp = ss(Ap, Bp, Cp, Dp, 'StateName',{'Int', s1, s2, s3});

    % Print input-output transfer function from state-space
    fprintf('Open Loop System\n')
    tfsysp = tf(sysp);
    if tfsysp.num{1}(end) ~= 0
        ps = pole(sys);
        fprintf('Poles:%f,%f,%f\n', ps(1),ps(2),ps(3));
        display(tfsysp);
    end

    % ----------------------------------------------------------
    % TODO (Checkoff 5): Complete Qp and Rp
    % ----------------------------------------------------------
    Qp = diag([0.0,0.0,0.0,0.0]);   % FIX THIS FOURTH
    Rp = diag(1);                   % FIX THIS FOURTH

    %Kp = [0.0, 0.0, 0.0, 0.0];
    Klqrp = lqr(sysp,Qp,Rp);

    % Plot the phase margin for the system
    sysph = ss(Ap, Bp, Cp, Dp);  %FIX THIS FOURTH
    figure(3);
    margin(sysph);

    % ----------------------------------------------------------
    % TODO (Checkoff 5): Complete Aclp, Bclp and Kr.
    % ----------------------------------------------------------
    Kr = 1.0;  % FIX THIS FOURTH
    Apclp = Ap; % FIX THIS FOURTH
    Bpclp = [0.0;0.0;0.0;0.0]; % FIX THIS FOURTH
    Cpclp = Cp;
    Dpclp = Dp;

    fprintf('closed-Loop System\n')
    sysp_clp = ss(Apclp, Bpclp, Cpclp, Dpclp);
    tfsysp_clp = tf(sysp_clp);
    if tfsys.num{1}(end) ~= 0
        ps = pole(sysp_clp);
        fprintf('Poles:%f,%f,%f %f\n', ps(1),ps(2),ps(3),ps(4));
        display(tfsysp_clp);
    end


    % Matrices for plotting
    Cplotp = [Klqrp; eye(4);];
    Dplotp = [0.0; zeros(4,1)];

    % Closed Loop systen for plotting
    sysp_clp = ss(Apclp, Bpclp, Cplotp, Dplotp, ...
        'OutputName', {'cmd','Integral',s1,s2,s3});

    % Plot step response
    figure(4);
    step(sysp_clp,0.5); grid;
    title(sprintf("Step responses for state space (with integrator)"));
    fprintf('Copy-paste lines below into Teensy Sketch!\n');
    fprintf('#define offsetKint %f \n#define offsetK%s %f \n#define offsetK%s %f \n#define offsetK%s %f \n', Klqrp(1),s1,Klqrp(2),s2,Klqrp(3),s3,Klqrp(4));
    fprintf('\nDone With Integrator\n');
end
