function plotSys(t, ySys, np, ns, uDist, disturbState, windowTitle)
% Plots results from simulating measured-state or observed-state fdback

maxUdist = max(abs(uDist));
if(maxUdist > 0)
    scaleUdist = 0.5*max(abs(ySys(:,1+disturbState)))/maxUdist;
    uDist = scaleUdist*uDist;
end
nSigs = size(ySys,2);
figure('name', windowTitle);
subplot(np,1,1);
plot(t,ySys(:,1));
title('Command');
for i = 0:ns-1
    if i == 0, varName = 'Y='; else, varName = ''; end
    subplot(np,1,2+i);
    hold on; 
    plot(t,ySys(:,2+i));
    if(nSigs > np+i) 
        plot(t,ySys(:,np+i+1)); 
        title(sprintf('%s X%d(blue)   X%dEst(red)',varName, i+1,i+1));
    else
        title(sprintf('%s X%d(blue)', varName,i+1));
    end
    hold off;
    if maxUdist > 0 &&  i == disturbState-1
        hold on; plot(t, uDist, "g"); hold off;
        subtitle('normalized disturbance in green');
    end
end

end