function M = synthData(Fmin, Fmax, nPts)
% Create synthetic data in sweeper format ***********************
% H poles at 0.1, 1, 10, Controller zero at 18, loop gain 1.8

% Create log spaced frequency points from Fmin to Fmax hertz
logFmin = log2(Fmin);
logFmax = log2(Fmax);
Fone = 2.^linspace(logFmin,logFmax,nPts)';
F = [Fone; Fone; Fone(1:end-floor(nPts/2))];  % Create 2 1/2 copies of sweep
jW = 1i*2*pi*F;

% Frequency Response for a plant stabilized with a PD controller
% Ydesired to Y output, or closed-loop transfer function*********
%   HYd2Y(s) = K(s)H(s)/(1 + K(s)H(s))
%   This case: K(s) = 0.1*(18 + s),  H(s) = 10/((s+0.1)(s+1)(s+10))
%   KjW = (1.8 + 0.1*jW), HjW = 10/((jW+0.1)(jW+1)(jW+10)
%   HYd2YjW = KjW*HjW/(1+KjW*Hjw), which can be  simplified.
HYd2YjW = 10*(1.8 + 0.1*jW)./((jW+0.1).*(jW+1).*(jW+10) + 10*(1.8+0.1*jW));

% Transfer function from Y_desired to U (plant input)
%   HYd2U(s) = HYd2Y(s)/H(s), or HYd2UjW = HYd2Yjw/Hjw
HYd2UjW = HYd2YjW.*((jW+10).*(jW+1).*(jW+0.1)/10.0);  % Notice "dot-divide"

% Fill in the five column M array
M = zeros(length(jW),5);
M(:,1) = F; % Second column has frequency points
M(:,2) = real(HYd2UjW); % controller real
M(:,3) = imag(HYd2UjW); % controller imag
M(:,4) = real(HYd2YjW); % output real
M(:,5) = imag(HYd2YjW); % output imag

end