import matplotlib.pyplot as plot
import numpy as np
import datetime
import serial
import signal
import sys
import serial.tools.list_ports

#Automatically finds Teensy USB port, then echos received data into a file.

def port_scan():
    ports = list(serial.tools.list_ports.comports())
    port_dict_all = {i: [ports[i], ports[i].vid] for i in range(len(ports))}
    port_dict = []

    for p in port_dict_all:
        if port_dict_all[p][1] == 5824:  # 5824 is Teensy ID.
            port_dict.append(port_dict_all[p][0])

    return port_dict

serial_connected = False

def connect_serial(outFile):
    baud = 4000000
    global ser
    global serial_connected
    serial_conn = False
    while True:
        s_list = port_scan()
        for s in s_list:  # Loop through Teensy ports until one responds.
            ser = serial.Serial(port = s[0], 
                                baudrate=baud,
                                parity=serial.PARITY_NONE, 
                                stopbits=serial.STOPBITS_ONE, 
                                bytesize=serial.EIGHTBITS,
                                timeout=1000000) 
            try: 
                strData = ser.readline()  # First try,
                if len(strData) > 10:
                    serial_conn = True
                    break
                else:
                    strData = ser.readline() # Second try,
                    if len(strData) > 10:
                        serial_conn = True
                        break
            except Exception as e:
                ser.close()
                outFile.close()
                serial_conn = False

        if serial_conn:
            break
        
    print("Serial Connected!")
    if ser.isOpen():
        print(ser.name + ' is open...')
        serial_connected = True
        return True

    
def keepReading(outFile):
    global ser
    global serial_connected

    while True:
        if not serial_connected:
            connect_serial(outFile)

        try:
            strData = ser.readline()

        except Exception as e: 
                print("to")
                break

        floatData = np.fromstring(strData, dtype=float, sep=',')
        s = str(strData)
        s = s[2:-5] + "; "
        print(s)
        outFile.write(s)



def signal_handler(sig, frame):
    global outFile
    outFile.close()
    print('Exiting....')
    sys.exit(0)
    
if len(sys.argv) > 1:
    fname = sys.argv[1]
else:
    fname = 'sweep.csv'

outFile = open(fname,'w')

signal.signal(signal.SIGINT, signal_handler)

keepReading(outFile)
outFile.close()
