function sys = labFitter(numPoles,numZeros,M)
% MATLAB code for reading controller and closed-loop frequency response
% and then estimating state-space model for the open-loop system.
%
% M should be an nX5 real matrix, n=number of measurements. 
% Columns: Freq, real(U), imag(U), real(Y), imag(Y) ;
% Finds state-space model for transfer function from U->Y.
% Look for ***FIX THIS!!!*** where you need to add/edit

% Compute the average of several frequency sweeps.
Frequency = M(:,1);
freq = sort(unique(Frequency)); % Set of unique frequencies
freqMap = containers.Map(freq,1:length(freq)); % Maps freqs to indices
Msort = zeros(size(freq,1),size(M,2));  % Matrix of averages.
count = zeros(size(freq)); 
for n = 1:length(Frequency)
    nFreq = freqMap(Frequency(n));
    Msort(nFreq,:) = Msort(nFreq,:) + M(n,:);
    count(nFreq) = count(nFreq) + 1.0;
end
for col = 1:size(Msort,2)
    Msort(:,col) = Msort(:,col)./count;
end


% Convert to complex frequency response and create idfrd object
y_resp = Msort(:,4) + 1j*Msort(:,5);  % Y: output 
u_resp = Msort(:,2) + 1j*Msort(:,3);  % U: input
Ymeas = idfrd(y_resp, freq*2*pi,0);   % Ymeas is the TF from Y_D to Y
Umeas = idfrd(u_resp, freq*2*pi, 0);  % Umeas is the TF from Y_D to U

% These frequency responses can be multiplied and divided!
Hmeas = Ymeas/Umeas;   % *** Why this formula?

% Plot frequency responses
figure(1); clf;
bodeplot(Ymeas); hold on;
bodeplot(Umeas); 
bodeplot(Hmeas); 
hold off;
legend('Measured Y_D->Y', 'Measured Y_D->U','Measured U->Y');


% Use TFEST to estimate state-space model of U->Y transfer function.
opts = tfestOptions('WeightingFilter', 'inv');  % Seemed to help.
systf = tfest(Hmeas,numPoles,numZeros,opts); % Fit transfer function
sysNf = ss(systf);  % Convert transfer function to state-space
sysC = canon(sysNf, 'companion');  % Begin state transformation. 
sys = ss(sysC.A', sysC.C', sysC.B', sysC.D); % Finish transforming.

%disp('Predicted system');
tfsys = zpk(sys);
display('Predicted transfer function');
display(tfsys);


figure(2); clf;
bode(sys,Hmeas);
legend('Estimated U->Y', 'Measured U->Y');
end

