function [yMsf,yObsf,t, uDist] = simMsfObsf(A, B, C, K, Kr, L, ...
    Byd, Bdist, Bnoise, dt)

% Three seconds of simulation using 500 points or dt.
if exist('dt', 'var') 
    t = 0:dt:5;
else 
    t = 0:1/1000:5; 
end

% yd:-inAmp to inAmp 1/3 of the way through simulation
yd = -ones(length(t), 1); % negative initial value
yd(floor(length(t)/2):end) = 1; % steps up to positive final value.

% disturbance
uDist = zeros(length(t),1); 
startDist = floor(length(t)*3/4);
lengthDist = floor(length(t)*1/50);
uDist(startDist:startDist+lengthDist) = 1; 

% Noise
uSensorNoise = rand(length(t),1)-0.5;

% Concatenate the three inputs: yd, udisturb, and uSensorNoise.
u = [yd,uDist,uSensorNoise];

% DT Measured-State Feedback (msf) System Matrices
AdMsf = A-B*K;  
BdMsf = [Byd,Bdist,Bnoise];  % Three inputs: y_d, disturbance, noise.

% Generate measured-state feedback output matrices for plotting.
CdMsfPlot = [-K; eye(size(AdMsf))];  % Control cmd followed by states.
DdMsfPlot = zeros(size(CdMsfPlot,1),3);  % 3 columns for y_d,noise,disturbance.
DdMsfPlot(1,1) = Kr;

% Create Measured-State Feedback system
if exist('dt', 'var') 
    sysMsf = ss(AdMsf,BdMsf,CdMsfPlot,DdMsfPlot,dt);
else 
    sysMsf = ss(AdMsf,BdMsf,CdMsfPlot,DdMsfPlot);
end

% State+Observer Input Matrix
BobsYd = [Byd; Byd]; % yd directly effects state and estimate identically.
BobsDist = [Bdist;zeros(size(Bdist))]; % Disturbance effects state not measurement.
BobsNoise = [zeros(size(Bnoise)); (C*Bnoise)*L]; % Noise affects measurement not state
Bobs = [BobsYd,BobsDist,BobsNoise];  % yd,disturb,and noise inputs

% Create A matrix for state+observer feedback system.
Aobs = [A,-B*K; L*C, A-(B*K+L*C)];  % Fix This!!!

% Generate Estimated-state feedback plotting matrices.
CobsPlot = [zeros(size(K)) -K; eye(size(Aobs))];
DobsPlot = zeros(size(CobsPlot,1),3);
DobsPlot(1,1) = Kr;

% Create Estimated-State Feedback system.
if exist('dt', 'var') 
    sysObsf = ss(Aobs,Bobs,CobsPlot,DobsPlot,dt);
else 
    sysObsf = ss(Aobs,Bobs,CobsPlot,DobsPlot); 
end

% Set Initial Conditions
x0ess = zeros(size(AdMsf,1),1);
x0obs = zeros(size(Aobs,1),1);

% Simulate Measured-State and Observer-State Systems
yObsf = lsim(sysObsf, u, t, x0obs);
yMsf = lsim(sysMsf,u,t, x0ess);

end