function [GsFit,GsSynth] = labFitter(numPoles,numZeros,DataMat,useData)
% MATLAB code for reading closed-loop frequency response
% and then estimates a transfer function model.  Takes a matrix of 
% measurement frequencies, real and imaginary part of controller 
% commands and R and I of measured output. 
% numPoles, numZeros: desired number of poles and zeros
% DataMat should be an nX5 real matrix, n=number of measurements. 
% Columns: Freq, real(U), imag(U), real(Y), imag(Y)
% Usesynth: generate synthetic data to test fitter.
% Returns transfer functions GsFit for fit, GsSynth for synthetic data.

% Look for ***FIX THIS!!!*** where you need to add/edit

% Read in frequencies from first column, remove duplicates, calculate omega.
numMeasures = size(DataMat,1); % number of frequency response measurements
numVars = size(DataMat,2); % number of variables at each frequency
measFreq = DataMat(:,1);
freq = sort(unique(measFreq)); % Set of unique frequencies
s = tf('s');

% for each frequency, average over measurements 
freqMap = containers.Map(freq,1:size(freq,1)); % Maps freqs to indices
AvgDataMat = zeros(size(freq,1),size(DataMat,2));  % Matrix of averages.
measuresPerFreq = zeros(size(freq)); 
for n = 1:numMeasures
    freqIndex = freqMap(measFreq(n));
    AvgDataMat(freqIndex,:) = AvgDataMat(freqIndex,:) + DataMat(n,:);
    measuresPerFreq(freqIndex) = measuresPerFreq(freqIndex) + 1.0;
end
for var = 1:numVars
    AvgDataMat(:,var) = AvgDataMat(:,var)./measuresPerFreq;
end

% Generate complex data and omega vector.
GjwMeas = AvgDataMat(:,4) + 1j*AvgDataMat(:,5);  % Measured output 
KjwMeas = AvgDataMat(:,2) + 1j*AvgDataMat(:,3);  % Controller output
numFreqs = size(freq,1);
jomega = 1j*2*pi*freq;  


% Generate synthetic data.
Beta = -12.5;  %********FIX THIS (Use your calibrated Beta******
Gamma = 90;    %********FIX THIS (Use your calibrated Gamma*****
GsSynth = feedback((0.5+0.2*s)*(-Gamma*Beta)/(s^2*(s-Beta)),1);
[GMag,Gangle] = bode(GsSynth,2*pi*freq);
GMag = squeeze(GMag);
Gangle = squeeze(Gangle);
GjwSynth = GMag.*exp(1j*deg2rad(Gangle));


% Fit to measured or synthetic data.
Gjw = GjwSynth;
if useData
   Gjw = GjwMeas; 
end

% Compute jw^k and jw^k*G(jw) matrices 
GW= zeros(numFreqs,numPoles);  
W = zeros(numFreqs,numZeros+1);
for i = 1:numFreqs
    for k = 1:numPoles+1
        GW(i,k) = Gjw(i)*(jomega(i))^(k-1);
    end
    for k = 1:numZeros+1
        W(i,k) = (jomega(i))^(k-1);
    end
end

% Set up least squares system for polynomial coefficients.
% Note that we have assumed that a^numPoles = 1
%******Fix the lines below when changing normalization
B = -GW(:,end);    % B= -(last col of GW), what if B = -GW(:,1)?
A = [GW(:,1:end-1), -W]; % cols(A) = cols(GW(1:end-1)) next to cols(W)
                         % what does A=[GW(:,2:end), -W] do?
                         
% Create double-length vector and matrix by appending complex conjugates
% You will use this later!
Bcc =[B; conj(B)];  % Bcc has twice as many rows as B
Acc = [A; conj(A)]; % Acc has twice as many rows as A

% determine a's and b's for transfer function by least-squares.
abcoeffComplex = A\B;  %******Fix this when using complex conj
display(abcoeffComplex);
abcoeffs = real(abcoeffComplex);
display(abcoeffs);

% Extract a's and b's from the abcoeff vector.
bb = abcoeffs(end-numZeros:end)';
aa = abcoeffs(1:numPoles);

% ********Fix lines below when changing normalization
% The line below adds a 1 to the bottom of the aa vector
aa(end+1) = 1;  % the coefficient for s^numPoles is one.
% The line below adds 1 to top of the aa vector
%aa = [1; aa];

% Calculate transfer function and frequency response from coeffs.
Den = 0;
Denjw = zeros(numFreqs,1);
for k = 1:numPoles+1
    Den = Den + aa(k)*s^(k-1);
    for i = 1:numFreqs
        Denjw(i) = Denjw(i) + aa(k)*(jomega(i))^(k-1);
    end
end
Num = 0;
Numjw = zeros(numFreqs,1);
for k = 1:numZeros+1
    Num = Num + bb(k)*s^(k-1);
    for i = 1:numFreqs
        Numjw(i) = Numjw(i) + bb(k)*(jomega(i))^(k-1);
    end
end
GsFit = Num/Den;
GjwFit = Numjw./Denjw;

figure(1);
subplot(2,1,1)
plot(freq,abs(GjwFit),'b*'); 
hold on;
plot(freq,abs(GjwMeas),'r');
plot(freq,abs(GjwSynth),'g');
hold off;
title('Magnitudes vs freq(hz) fit(*),Meas(red),Synth(green)')
subplot(2,1,2)
plot(freq,(180/pi)*angle(GjwFit),'b*'); 
hold on;
plot(freq,(180/pi)*angle(GjwMeas),'r');
plot(freq,(180/pi)*angle(GjwSynth),'green');
hold off;
title('Angles(degrees) vs freq(hz) fit(*),Meas(red),Synth(green)')
end